/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertPathHelperImpl;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.KnownOIDs;
import sun.security.x509.CRLNumberExtension;
import sun.security.x509.X500Name;

public class X509CRLSelector
implements CRLSelector {
    private static final Debug debug;
    private HashSet<Object> issuerNames;
    private HashSet<X500Principal> issuerX500Principals;
    private BigInteger minCRL;
    private BigInteger maxCRL;
    private Date dateAndTime;
    private X509Certificate certChecking;
    private long skew = 0L;

    public void setIssuers(Collection<X500Principal> collection) {
        if (collection == null || collection.isEmpty()) {
            this.issuerNames = null;
            this.issuerX500Principals = null;
        } else {
            this.issuerX500Principals = new HashSet<X500Principal>(collection);
            this.issuerNames = new HashSet();
            for (X500Principal x500Principal : this.issuerX500Principals) {
                this.issuerNames.add(x500Principal.getEncoded());
            }
        }
    }

    public void setIssuerNames(Collection<?> collection) throws IOException {
        if (collection == null || collection.size() == 0) {
            this.issuerNames = null;
            this.issuerX500Principals = null;
        } else {
            HashSet<Object> hashSet = X509CRLSelector.cloneAndCheckIssuerNames(collection);
            this.issuerX500Principals = X509CRLSelector.parseIssuerNames(hashSet);
            this.issuerNames = hashSet;
        }
    }

    public void addIssuer(X500Principal x500Principal) {
        this.addIssuerNameInternal(x500Principal.getEncoded(), x500Principal);
    }

    public void addIssuerName(String string) throws IOException {
        this.addIssuerNameInternal(string, new X500Name(string).asX500Principal());
    }

    public void addIssuerName(byte[] byArray) throws IOException {
        this.addIssuerNameInternal(byArray.clone(), new X500Name(byArray).asX500Principal());
    }

    private void addIssuerNameInternal(Object object, X500Principal x500Principal) {
        if (this.issuerNames == null) {
            this.issuerNames = new HashSet();
        }
        if (this.issuerX500Principals == null) {
            this.issuerX500Principals = new HashSet();
        }
        this.issuerNames.add(object);
        this.issuerX500Principals.add(x500Principal);
    }

    private static HashSet<Object> cloneAndCheckIssuerNames(Collection<?> collection) throws IOException {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object obj : collection) {
            if (!(obj instanceof byte[]) && !(obj instanceof String)) {
                throw new IOException("name not byte array or String");
            }
            if (obj instanceof byte[]) {
                hashSet.add(((byte[])obj).clone());
                continue;
            }
            hashSet.add(obj);
        }
        return hashSet;
    }

    private static HashSet<Object> cloneIssuerNames(Collection<Object> collection) {
        try {
            return X509CRLSelector.cloneAndCheckIssuerNames(collection);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static HashSet<X500Principal> parseIssuerNames(Collection<Object> collection) throws IOException {
        HashSet<X500Principal> hashSet = new HashSet<X500Principal>();
        for (Object object : collection) {
            if (object instanceof String) {
                hashSet.add(new X500Name((String)object).asX500Principal());
                continue;
            }
            try {
                hashSet.add(new X500Principal((byte[])object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (IOException)new IOException("Invalid name").initCause(illegalArgumentException);
            }
        }
        return hashSet;
    }

    public void setMinCRLNumber(BigInteger bigInteger) {
        this.minCRL = bigInteger;
    }

    public void setMaxCRLNumber(BigInteger bigInteger) {
        this.maxCRL = bigInteger;
    }

    public void setDateAndTime(Date date) {
        this.dateAndTime = date == null ? null : new Date(date.getTime());
        this.skew = 0L;
    }

    void setDateAndTime(Date date, long l) {
        this.dateAndTime = date == null ? null : new Date(date.getTime());
        this.skew = l;
    }

    public void setCertificateChecking(X509Certificate x509Certificate) {
        this.certChecking = x509Certificate;
    }

    public Collection<X500Principal> getIssuers() {
        if (this.issuerX500Principals == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.issuerX500Principals);
    }

    public Collection<Object> getIssuerNames() {
        if (this.issuerNames == null) {
            return null;
        }
        return X509CRLSelector.cloneIssuerNames(this.issuerNames);
    }

    public BigInteger getMinCRL() {
        return this.minCRL;
    }

    public BigInteger getMaxCRL() {
        return this.maxCRL;
    }

    public Date getDateAndTime() {
        if (this.dateAndTime == null) {
            return null;
        }
        return (Date)this.dateAndTime.clone();
    }

    public X509Certificate getCertificateChecking() {
        return this.certChecking;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X509CRLSelector: [\n");
        if (this.issuerNames != null) {
            stringBuffer.append("  IssuerNames:\n");
            Iterator<Object> iterator = this.issuerNames.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("    " + iterator.next() + "\n");
            }
        }
        if (this.minCRL != null) {
            stringBuffer.append("  minCRLNumber: " + this.minCRL + "\n");
        }
        if (this.maxCRL != null) {
            stringBuffer.append("  maxCRLNumber: " + this.maxCRL + "\n");
        }
        if (this.dateAndTime != null) {
            stringBuffer.append("  dateAndTime: " + this.dateAndTime + "\n");
        }
        if (this.certChecking != null) {
            stringBuffer.append("  Certificate being checked: " + this.certChecking + "\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public boolean match(CRL cRL) {
        Object object;
        Object object2;
        Object object3;
        if (!(cRL instanceof X509CRL)) {
            return false;
        }
        X509CRL x509CRL = (X509CRL)cRL;
        if (this.issuerNames != null) {
            object3 = x509CRL.getIssuerX500Principal();
            object2 = this.issuerX500Principals.iterator();
            boolean bl = false;
            while (!bl && object2.hasNext()) {
                if (!object2.next().equals(object3)) continue;
                bl = true;
            }
            if (!bl) {
                if (debug != null) {
                    debug.println("X509CRLSelector.match: issuer DNs don't match");
                }
                return false;
            }
        }
        if (this.minCRL != null || this.maxCRL != null) {
            object3 = x509CRL.getExtensionValue(KnownOIDs.CRLNumber.value());
            if (object3 == null && debug != null) {
                debug.println("X509CRLSelector.match: no CRLNumber");
            }
            try {
                DerInputStream derInputStream = new DerInputStream((byte[])object3);
                object = derInputStream.getOctetString();
                CRLNumberExtension cRLNumberExtension = new CRLNumberExtension(Boolean.FALSE, object);
                object2 = cRLNumberExtension.get("value");
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.println("X509CRLSelector.match: exception in decoding CRL number");
                }
                return false;
            }
            if (this.minCRL != null && ((BigInteger)object2).compareTo(this.minCRL) < 0) {
                if (debug != null) {
                    debug.println("X509CRLSelector.match: CRLNumber too small");
                }
                return false;
            }
            if (this.maxCRL != null && ((BigInteger)object2).compareTo(this.maxCRL) > 0) {
                if (debug != null) {
                    debug.println("X509CRLSelector.match: CRLNumber too large");
                }
                return false;
            }
        }
        if (this.dateAndTime != null) {
            object3 = x509CRL.getThisUpdate();
            object2 = x509CRL.getNextUpdate();
            if (object2 == null) {
                if (debug != null) {
                    debug.println("X509CRLSelector.match: nextUpdate null");
                }
                return false;
            }
            Date date = this.dateAndTime;
            object = this.dateAndTime;
            if (this.skew > 0L) {
                date = new Date(this.dateAndTime.getTime() + this.skew);
                object = new Date(this.dateAndTime.getTime() - this.skew);
            }
            if (((Date)object).after((Date)object2) || date.before((Date)object3)) {
                if (debug != null) {
                    debug.println("X509CRLSelector.match: update out-of-range");
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public Object clone() {
        try {
            X509CRLSelector x509CRLSelector = (X509CRLSelector)super.clone();
            if (this.issuerNames != null) {
                x509CRLSelector.issuerNames = new HashSet<Object>(this.issuerNames);
                x509CRLSelector.issuerX500Principals = new HashSet<X500Principal>(this.issuerX500Principals);
            }
            return x509CRLSelector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString(), cloneNotSupportedException);
        }
    }

    static {
        CertPathHelperImpl.initialize();
        debug = Debug.getInstance("certpath");
    }
}

