/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.xni;

public class XMLString {
    public static final int DEFAULT_SIZE = 32;
    public char[] ch;
    public int offset;
    public int length;

    public XMLString() {
    }

    public XMLString(char[] cArray, int n, int n2) {
        this.setValues(cArray, n, n2);
    }

    public XMLString(XMLString xMLString) {
        this.setValues(xMLString);
    }

    public void setValues(char[] cArray, int n, int n2) {
        this.ch = cArray;
        this.offset = n;
        this.length = n2;
    }

    public void setValues(XMLString xMLString) {
        this.setValues(xMLString.ch, xMLString.offset, xMLString.length);
    }

    public void clear() {
        this.ch = null;
        this.offset = 0;
        this.length = -1;
    }

    public boolean equals(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return false;
        }
        if (this.length != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.ch[this.offset + i] == cArray[n + i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(String string) {
        if (string == null) {
            return false;
        }
        if (this.length != string.length()) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.ch[this.offset + i] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.length > 0 ? new String(this.ch, this.offset, this.length) : "";
    }

    public void append(char c) {
        if (this.length + 1 > this.ch.length) {
            int n = this.ch.length * 2;
            if (n < this.ch.length + 32) {
                n = this.ch.length + 32;
            }
            char[] cArray = new char[n];
            System.arraycopy(this.ch, 0, cArray, 0, this.length);
            this.ch = cArray;
        }
        this.ch[this.length] = c;
        ++this.length;
    }

    public void append(String string) {
        int n = string.length();
        if (this.length + n > this.ch.length) {
            int n2 = this.ch.length * 2;
            if (n2 < this.ch.length + n + 32) {
                n2 = this.ch.length + n + 32;
            }
            char[] cArray = new char[n2];
            System.arraycopy(this.ch, 0, cArray, 0, this.length);
            this.ch = cArray;
        }
        string.getChars(0, n, this.ch, this.length);
        this.length += n;
    }

    public void append(char[] cArray, int n, int n2) {
        if (this.length + n2 > this.ch.length) {
            int n3 = this.ch.length * 2;
            if (n3 < this.ch.length + n2 + 32) {
                n3 = this.ch.length + n2 + 32;
            }
            char[] cArray2 = new char[n3];
            System.arraycopy(this.ch, 0, cArray2, 0, this.length);
            this.ch = cArray2;
        }
        if (cArray != null && n2 > 0) {
            System.arraycopy(cArray, n, this.ch, this.length, n2);
            this.length += n2;
        }
    }

    public void append(XMLString xMLString) {
        this.append(xMLString.ch, xMLString.offset, xMLString.length);
    }
}

