/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.AnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Annotations;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantObject;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.generic.AnnotationEntryGen;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.FieldGenOrMethodGen;
import com.sun.org.apache.bcel.internal.generic.FieldObserver;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.util.BCELComparator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FieldGen
extends FieldGenOrMethodGen {
    private Object value = null;
    private static BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public boolean equals(Object object, Object object2) {
            FieldGen fieldGen = (FieldGen)object;
            FieldGen fieldGen2 = (FieldGen)object2;
            return Objects.equals(fieldGen.getName(), fieldGen2.getName()) && Objects.equals(fieldGen.getSignature(), fieldGen2.getSignature());
        }

        @Override
        public int hashCode(Object object) {
            FieldGen fieldGen = (FieldGen)object;
            return fieldGen.getSignature().hashCode() ^ fieldGen.getName().hashCode();
        }
    };
    private List<FieldObserver> observers;

    public FieldGen(int n, Type type, String string, ConstantPoolGen constantPoolGen) {
        super(n);
        this.setType(type);
        this.setName(string);
        this.setConstantPool(constantPoolGen);
    }

    public FieldGen(Field field, ConstantPoolGen constantPoolGen) {
        this(field.getAccessFlags(), Type.getType(field.getSignature()), field.getName(), constantPoolGen);
        Attribute[] attributeArray;
        for (Attribute attribute : attributeArray = field.getAttributes()) {
            if (attribute instanceof ConstantValue) {
                this.setValue(((ConstantValue)attribute).getConstantValueIndex());
                continue;
            }
            if (attribute instanceof Annotations) {
                AnnotationEntry[] annotationEntryArray;
                Annotations annotations = (Annotations)attribute;
                for (AnnotationEntry annotationEntry : annotationEntryArray = annotations.getAnnotationEntries()) {
                    this.addAnnotationEntry(new AnnotationEntryGen(annotationEntry, constantPoolGen, false));
                }
                continue;
            }
            this.addAttribute(attribute);
        }
    }

    private void setValue(int n) {
        ConstantPool constantPool = super.getConstantPool().getConstantPool();
        Constant constant = constantPool.getConstant(n);
        this.value = ((ConstantObject)((Object)constant)).getConstantValue(constantPool);
    }

    public void setInitValue(String string) {
        this.checkType(ObjectType.getInstance("java.lang.String"));
        if (string != null) {
            this.value = string;
        }
    }

    public void setInitValue(long l) {
        this.checkType(Type.LONG);
        if (l != 0L) {
            this.value = l;
        }
    }

    public void setInitValue(int n) {
        this.checkType(Type.INT);
        if (n != 0) {
            this.value = n;
        }
    }

    public void setInitValue(short s) {
        this.checkType(Type.SHORT);
        if (s != 0) {
            this.value = (int)s;
        }
    }

    public void setInitValue(char c) {
        this.checkType(Type.CHAR);
        if (c != '\u0000') {
            this.value = (int)c;
        }
    }

    public void setInitValue(byte by) {
        this.checkType(Type.BYTE);
        if (by != 0) {
            this.value = (int)by;
        }
    }

    public void setInitValue(boolean bl) {
        this.checkType(Type.BOOLEAN);
        if (bl) {
            this.value = 1;
        }
    }

    public void setInitValue(float f) {
        this.checkType(Type.FLOAT);
        if ((double)f != 0.0) {
            this.value = Float.valueOf(f);
        }
    }

    public void setInitValue(double d) {
        this.checkType(Type.DOUBLE);
        if (d != 0.0) {
            this.value = d;
        }
    }

    public void cancelInitValue() {
        this.value = null;
    }

    private void checkType(Type type) {
        Type type2 = super.getType();
        if (type2 == null) {
            throw new ClassGenException("You haven't defined the type of the field yet");
        }
        if (!this.isFinal()) {
            throw new ClassGenException("Only final fields may have an initial value!");
        }
        if (!type2.equals(type)) {
            throw new ClassGenException("Types are not compatible: " + type2 + " vs. " + type);
        }
    }

    public Field getField() {
        String string = this.getSignature();
        int n = super.getConstantPool().addUtf8(super.getName());
        int n2 = super.getConstantPool().addUtf8(string);
        if (this.value != null) {
            this.checkType(super.getType());
            int n3 = this.addConstant();
            this.addAttribute(new ConstantValue(super.getConstantPool().addUtf8("ConstantValue"), 2, n3, super.getConstantPool().getConstantPool()));
        }
        this.addAnnotationsAsAttribute(super.getConstantPool());
        return new Field(super.getAccessFlags(), n, n2, this.getAttributes(), super.getConstantPool().getConstantPool());
    }

    private void addAnnotationsAsAttribute(ConstantPoolGen constantPoolGen) {
        Attribute[] attributeArray;
        for (Attribute attribute : attributeArray = AnnotationEntryGen.getAnnotationAttributes(constantPoolGen, super.getAnnotationEntries())) {
            this.addAttribute(attribute);
        }
    }

    private int addConstant() {
        switch (super.getType().getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return super.getConstantPool().addInteger((Integer)this.value);
            }
            case 6: {
                return super.getConstantPool().addFloat(((Float)this.value).floatValue());
            }
            case 7: {
                return super.getConstantPool().addDouble((Double)this.value);
            }
            case 11: {
                return super.getConstantPool().addLong((Long)this.value);
            }
            case 14: {
                return super.getConstantPool().addString((String)this.value);
            }
        }
        throw new IllegalStateException("Unhandled : " + super.getType().getType());
    }

    @Override
    public String getSignature() {
        return super.getType().getSignature();
    }

    public void addObserver(FieldObserver fieldObserver) {
        if (this.observers == null) {
            this.observers = new ArrayList<FieldObserver>();
        }
        this.observers.add(fieldObserver);
    }

    public void removeObserver(FieldObserver fieldObserver) {
        if (this.observers != null) {
            this.observers.remove(fieldObserver);
        }
    }

    public void update() {
        if (this.observers != null) {
            for (FieldObserver fieldObserver : this.observers) {
                fieldObserver.notify(this);
            }
        }
    }

    public String getInitValue() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public final String toString() {
        String string = Utility.accessToString(super.getAccessFlags());
        string = string.isEmpty() ? "" : string + " ";
        String string2 = super.getType().toString();
        String string3 = this.getName();
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(string).append(string2).append(" ").append(string3);
        String string4 = this.getInitValue();
        if (string4 != null) {
            stringBuilder.append(" = ").append(string4);
        }
        return stringBuilder.toString();
    }

    public FieldGen copy(ConstantPoolGen constantPoolGen) {
        FieldGen fieldGen = (FieldGen)this.clone();
        fieldGen.setConstantPool(constantPoolGen);
        return fieldGen;
    }

    public static BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(BCELComparator bCELComparator) {
        bcelComparator = bCELComparator;
    }

    public boolean equals(Object object) {
        return bcelComparator.equals(this, object);
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }
}

