/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModulePackages
extends Attribute {
    private int[] packageIndexTable;

    public ModulePackages(ModulePackages modulePackages) {
        this(modulePackages.getNameIndex(), modulePackages.getLength(), modulePackages.getPackageIndexTable(), modulePackages.getConstantPool());
    }

    public ModulePackages(int n, int n2, int[] nArray, ConstantPool constantPool) {
        super((byte)23, n, n2, constantPool);
        this.packageIndexTable = nArray != null ? nArray : new int[]{};
    }

    ModulePackages(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (int[])null, constantPool);
        int n3 = dataInput.readUnsignedShort();
        this.packageIndexTable = new int[n3];
        for (int i = 0; i < n3; ++i) {
            this.packageIndexTable[i] = dataInput.readUnsignedShort();
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitModulePackages(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.packageIndexTable.length);
        for (int n : this.packageIndexTable) {
            dataOutputStream.writeShort(n);
        }
    }

    public int[] getPackageIndexTable() {
        return this.packageIndexTable;
    }

    public int getNumberOfPackages() {
        return this.packageIndexTable == null ? 0 : this.packageIndexTable.length;
    }

    public String[] getPackageNames() {
        String[] stringArray = new String[this.packageIndexTable.length];
        for (int i = 0; i < this.packageIndexTable.length; ++i) {
            stringArray[i] = super.getConstantPool().getConstantString(this.packageIndexTable[i], (byte)20).replace('/', '.');
        }
        return stringArray;
    }

    public void setPackageIndexTable(int[] nArray) {
        this.packageIndexTable = nArray != null ? nArray : new int[]{};
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ModulePackages(");
        stringBuilder.append(this.packageIndexTable.length);
        stringBuilder.append("):\n");
        for (int n : this.packageIndexTable) {
            String string = super.getConstantPool().getConstantString(n, (byte)20);
            stringBuilder.append("  ").append(Utility.compactClassName(string, false)).append("\n");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        ModulePackages modulePackages = (ModulePackages)this.clone();
        if (this.packageIndexTable != null) {
            modulePackages.packageIndexTable = new int[this.packageIndexTable.length];
            System.arraycopy(this.packageIndexTable, 0, modulePackages.packageIndexTable, 0, this.packageIndexTable.length);
        }
        modulePackages.setConstantPool(constantPool);
        return modulePackages;
    }
}

