/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantObject;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantString
extends Constant
implements ConstantObject {
    private int stringIndex;

    public ConstantString(ConstantString constantString) {
        this(constantString.getStringIndex());
    }

    ConstantString(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedShort());
    }

    public ConstantString(int n) {
        super((byte)8);
        this.stringIndex = n;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantString(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getTag());
        dataOutputStream.writeShort(this.stringIndex);
    }

    public int getStringIndex() {
        return this.stringIndex;
    }

    public void setStringIndex(int n) {
        this.stringIndex = n;
    }

    @Override
    public String toString() {
        return super.toString() + "(stringIndex = " + this.stringIndex + ")";
    }

    @Override
    public Object getConstantValue(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.stringIndex, (byte)1);
        return ((ConstantUtf8)constant).getBytes();
    }

    public String getBytes(ConstantPool constantPool) {
        return (String)this.getConstantValue(constantPool);
    }
}

