/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.Alert;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ClientHello;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeAbsence;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Record;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLStringizer;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.Utilities;
import sun.security.util.ByteArrays;

final class RenegoInfoExtension {
    static final HandshakeProducer chNetworkProducer = new CHRenegotiationInfoProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHRenegotiationInfoConsumer();
    static final HandshakeAbsence chOnLoadAbsence = new CHRenegotiationInfoAbsence();
    static final HandshakeProducer shNetworkProducer = new SHRenegotiationInfoProducer();
    static final SSLExtension.ExtensionConsumer shOnLoadConsumer = new SHRenegotiationInfoConsumer();
    static final HandshakeAbsence shOnLoadAbsence = new SHRenegotiationInfoAbsence();
    static final SSLStringizer rniStringizer = new RenegotiationInfoStringizer();

    RenegoInfoExtension() {
    }

    private static final class CHRenegotiationInfoAbsence
    implements HandshakeAbsence {
        private CHRenegotiationInfoAbsence() {
        }

        @Override
        public void absent(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            ClientHello.ClientHelloMessage clientHelloMessage = (ClientHello.ClientHelloMessage)handshakeMessage;
            if (!serverHandshakeContext.conContext.isNegotiated) {
                for (int n : clientHelloMessage.cipherSuiteIds) {
                    if (n != CipherSuite.TLS_EMPTY_RENEGOTIATION_INFO_SCSV.id) continue;
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.finest("Safe renegotiation, using the SCSV signgling", new Object[0]);
                    }
                    serverHandshakeContext.conContext.secureRenegotiation = true;
                    return;
                }
                if (!HandshakeContext.allowLegacyHelloMessages) {
                    throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Failed to negotiate the use of secure renegotiation");
                }
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("Warning: No renegotiation indication in ClientHello, allow legacy ClientHello", new Object[0]);
                }
                serverHandshakeContext.conContext.secureRenegotiation = false;
            } else {
                if (serverHandshakeContext.conContext.secureRenegotiation) {
                    throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Inconsistent secure renegotiation indication");
                }
                if (HandshakeContext.allowUnsafeRenegotiation) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.warning("Using insecure renegotiation", new Object[0]);
                    }
                } else {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.fine("Terminate insecure renegotiation", new Object[0]);
                    }
                    throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsafe renegotiation is not allowed");
                }
            }
        }
    }

    private static final class CHRenegotiationInfoConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHRenegotiationInfoConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            RenegotiationInfoSpec renegotiationInfoSpec;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_RENEGOTIATION_INFO)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable extension: " + SSLExtension.CH_RENEGOTIATION_INFO.name, new Object[0]);
                }
                return;
            }
            try {
                renegotiationInfoSpec = new RenegotiationInfoSpec(byteBuffer);
            }
            catch (IOException iOException) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
            }
            if (!serverHandshakeContext.conContext.isNegotiated) {
                if (renegotiationInfoSpec.renegotiatedConnection.length != 0) {
                    throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Invalid renegotiation_info extension data: not empty");
                }
                serverHandshakeContext.conContext.secureRenegotiation = true;
            } else {
                if (!serverHandshakeContext.conContext.secureRenegotiation) {
                    throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "The renegotiation_info is present in a insecure renegotiation");
                }
                if (!MessageDigest.isEqual(serverHandshakeContext.conContext.clientVerifyData, renegotiationInfoSpec.renegotiatedConnection)) {
                    throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Invalid renegotiation_info extension data: incorrect verify data in ClientHello");
                }
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CH_RENEGOTIATION_INFO, RenegotiationInfoSpec.NOMINAL);
        }
    }

    private static final class CHRenegotiationInfoProducer
    implements HandshakeProducer {
        private CHRenegotiationInfoProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_RENEGOTIATION_INFO)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable renegotiation_info extension", new Object[0]);
                }
                return null;
            }
            if (!clientHandshakeContext.conContext.isNegotiated) {
                if (clientHandshakeContext.activeCipherSuites.contains((Object)CipherSuite.TLS_EMPTY_RENEGOTIATION_INFO_SCSV)) {
                    return null;
                }
                byte[] byArray = new byte[]{0};
                clientHandshakeContext.handshakeExtensions.put(SSLExtension.CH_RENEGOTIATION_INFO, RenegotiationInfoSpec.NOMINAL);
                return byArray;
            }
            if (clientHandshakeContext.conContext.secureRenegotiation) {
                byte[] byArray = new byte[clientHandshakeContext.conContext.clientVerifyData.length + 1];
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                Record.putBytes8(byteBuffer, clientHandshakeContext.conContext.clientVerifyData);
                clientHandshakeContext.handshakeExtensions.put(SSLExtension.CH_RENEGOTIATION_INFO, RenegotiationInfoSpec.NOMINAL);
                return byArray;
            }
            if (HandshakeContext.allowUnsafeRenegotiation) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("Using insecure renegotiation", new Object[0]);
                }
                return null;
            }
            throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "insecure renegotiation is not allowed");
        }
    }

    static final class RenegotiationInfoSpec
    implements SSLExtension.SSLExtensionSpec {
        static final RenegotiationInfoSpec NOMINAL = new RenegotiationInfoSpec(new byte[0]);
        private final byte[] renegotiatedConnection;

        private RenegotiationInfoSpec(byte[] byArray) {
            this.renegotiatedConnection = Arrays.copyOf(byArray, byArray.length);
        }

        private RenegotiationInfoSpec(ByteBuffer byteBuffer) throws IOException {
            if (!byteBuffer.hasRemaining() || byteBuffer.remaining() < 1) {
                throw new SSLProtocolException("Invalid renegotiation_info extension data: insufficient data");
            }
            this.renegotiatedConnection = Record.getBytes8(byteBuffer);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"renegotiated connection\": '['{0}']'", Locale.ENGLISH);
            if (this.renegotiatedConnection.length == 0) {
                Object[] objectArray = new Object[]{"<no renegotiated connection>"};
                return messageFormat.format(objectArray);
            }
            Object[] objectArray = new Object[]{Utilities.toHexString(this.renegotiatedConnection)};
            return messageFormat.format(objectArray);
        }
    }

    private static final class RenegotiationInfoStringizer
    implements SSLStringizer {
        private RenegotiationInfoStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new RenegotiationInfoSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }

    private static final class SHRenegotiationInfoAbsence
    implements HandshakeAbsence {
        private SHRenegotiationInfoAbsence() {
        }

        @Override
        public void absent(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            RenegotiationInfoSpec renegotiationInfoSpec = (RenegotiationInfoSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.CH_RENEGOTIATION_INFO);
            if (renegotiationInfoSpec == null && !clientHandshakeContext.activeCipherSuites.contains((Object)CipherSuite.TLS_EMPTY_RENEGOTIATION_INFO_SCSV)) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Missing renegotiation_info and SCSV detected in ClientHello");
            }
            if (!clientHandshakeContext.conContext.isNegotiated) {
                if (!HandshakeContext.allowLegacyHelloMessages) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Failed to negotiate the use of secure renegotiation");
                }
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("Warning: No renegotiation indication in ServerHello, allow legacy ServerHello", new Object[0]);
                }
                clientHandshakeContext.conContext.secureRenegotiation = false;
            } else {
                if (clientHandshakeContext.conContext.secureRenegotiation) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Inconsistent secure renegotiation indication");
                }
                if (HandshakeContext.allowUnsafeRenegotiation) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.warning("Using insecure renegotiation", new Object[0]);
                    }
                } else {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.fine("Terminate insecure renegotiation", new Object[0]);
                    }
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsafe renegotiation is not allowed");
                }
            }
        }
    }

    private static final class SHRenegotiationInfoConsumer
    implements SSLExtension.ExtensionConsumer {
        private SHRenegotiationInfoConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            RenegotiationInfoSpec renegotiationInfoSpec;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            RenegotiationInfoSpec renegotiationInfoSpec2 = (RenegotiationInfoSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.CH_RENEGOTIATION_INFO);
            if (renegotiationInfoSpec2 == null && !clientHandshakeContext.activeCipherSuites.contains((Object)CipherSuite.TLS_EMPTY_RENEGOTIATION_INFO_SCSV)) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Missing renegotiation_info and SCSV detected in ClientHello");
            }
            try {
                renegotiationInfoSpec = new RenegotiationInfoSpec(byteBuffer);
            }
            catch (IOException iOException) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
            }
            if (!clientHandshakeContext.conContext.isNegotiated) {
                if (renegotiationInfoSpec.renegotiatedConnection.length != 0) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid renegotiation_info in ServerHello: not empty renegotiated_connection");
                }
                clientHandshakeContext.conContext.secureRenegotiation = true;
            } else {
                int n = clientHandshakeContext.conContext.clientVerifyData.length + clientHandshakeContext.conContext.serverVerifyData.length;
                if (renegotiationInfoSpec.renegotiatedConnection.length != n) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid renegotiation_info in ServerHello: invalid renegotiated_connection length (" + renegotiationInfoSpec.renegotiatedConnection.length + ")");
                }
                byte[] byArray = clientHandshakeContext.conContext.clientVerifyData;
                if (!ByteArrays.isEqual(renegotiationInfoSpec.renegotiatedConnection, 0, byArray.length, byArray, 0, byArray.length)) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid renegotiation_info in ServerHello: unmatched client_verify_data value");
                }
                byte[] byArray2 = clientHandshakeContext.conContext.serverVerifyData;
                if (!ByteArrays.isEqual(renegotiationInfoSpec.renegotiatedConnection, byArray.length, n, byArray2, 0, byArray2.length)) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid renegotiation_info in ServerHello: unmatched server_verify_data value");
                }
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.SH_RENEGOTIATION_INFO, RenegotiationInfoSpec.NOMINAL);
        }
    }

    private static final class SHRenegotiationInfoProducer
    implements HandshakeProducer {
        private SHRenegotiationInfoProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            RenegotiationInfoSpec renegotiationInfoSpec = (RenegotiationInfoSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_RENEGOTIATION_INFO);
            if (renegotiationInfoSpec == null && !serverHandshakeContext.conContext.secureRenegotiation) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("Ignore unavailable renegotiation_info extension", new Object[0]);
                }
                return null;
            }
            if (!serverHandshakeContext.conContext.secureRenegotiation) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("No secure renegotiation has been negotiated", new Object[0]);
                }
                return null;
            }
            if (!serverHandshakeContext.conContext.isNegotiated) {
                byte[] byArray = new byte[]{0};
                serverHandshakeContext.handshakeExtensions.put(SSLExtension.SH_RENEGOTIATION_INFO, RenegotiationInfoSpec.NOMINAL);
                return byArray;
            }
            int n = serverHandshakeContext.conContext.clientVerifyData.length + serverHandshakeContext.conContext.serverVerifyData.length;
            byte[] byArray = new byte[n + 1];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Record.putInt8(byteBuffer, n);
            byteBuffer.put(serverHandshakeContext.conContext.clientVerifyData);
            byteBuffer.put(serverHandshakeContext.conContext.serverVerifyData);
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.SH_RENEGOTIATION_INFO, RenegotiationInfoSpec.NOMINAL);
            return byArray;
        }
    }
}

